#!/opt/local/bin/perl

use MP3::Tag;

$glbStrITunesLib = "$ENV{'HOME'}/Music/iTunes/iTunes Music Library.xml";
if (!-e $glbStrITunesLib) { die "ERROR! Cannot find the iTunes XML files\n"; }

open (FH,"<$glbStrITunesLib");
	@lines = <FH>;
close (FH);

$tmpCount = 1;
$boolFindGenre = 0;
$boolFindLoc = 0;
@arrBlankGenres = ();
@arrTracks = ();
@arrTracksSorted = ();
$tmpStrPrevLine = "";
@tmpArrSplit;
@tmpArrSplit2;

foreach $line (@lines)
{
	chomp $line;
	my $tmpStrLine = $line;

	if ($tmpCount > 1)
	{
		if ( (!$boolFindLoc) && ($tmpStrLine =~ m/<key>Track ID<\/key>/) )
		{
			if ($tmpStrPrevLine =~ m/<dict>/)
			{
				if ($boolFindGenre)
				{
					my @tmpArr2ndDim = ();
					push (@tmpArr2ndDim, $tmpArrSplit[1], $tmpArrSplit2[1]);
					push (@arrTracks, [ @tmpArr2ndDim ] );
				}
				@tmpArrSplit = split("<integer>", $tmpStrLine);
				$tmpArrSplit[1] =~ s/<\/integer>//;

				$boolFindLoc = 1;
				$boolFindGenre = 1;
			}
		}
		elsif ( ($boolFindLoc) && ($tmpStrLine =~ m/<key>Location<\/key>/) )
		{
			@tmpArrSplit2 = split("<string>file://localhost", $tmpStrLine);
			$tmpArrSplit2[1] =~ s/<\/string>//;
			$tmpArrSplit2[1] =~ s/%20/ /g;
			$tmpArrSplit2[1] =~ s/%23/#/g;
			$tmpArrSplit2[1] =~ s/&#38;/&/g;
			$tmpArrSplit2[1] =~ s/%5B/[/g;
			$tmpArrSplit2[1] =~ s/%5D/]/g;
			$tmpArrSplit2[1] =~ s/e%CC%81/é/g;
			$tmpArrSplit2[1] =~ s/i%CC%88/ï/g;
			$tmpArrSplit2[1] =~ s/o%CC%81/ó/g;

			$boolFindLoc = 0;
		}
		elsif ( ($boolFindGenre) && ($tmpStrLine =~ m/<key>Genre<\/key>/) )
		{
			$boolFindGenre = 0;
		}
	}

	$tmpStrPrevLine = $line;
	$tmpCount++;
}

# Sort @arrToRemove based on the DB ID
@arrTracksSorted = sort { $a->[0] cmp $b->[0] } @arrTracks;

foreach $tmpRefList (@arrTracksSorted)
{
	my $objMP3ID3v2;
	my @tmpArr2ndDim;
	my $tmpStrGenre = "";
	my $tmpStrLong = "";
	my $objMP3;

	$objMP3 = MP3::Tag->new(@$tmpRefList[1]);

	eval
	{
		$objMP3->get_tags();
	};
	if ($@)
	{
		print "WARNING - Cannot read tags from @$tmpRefList[1]\n";
		@$tmpRefList[0] = "ERRFILE".@$tmpRefList[0];
	}

	if (exists $objMP3->{ID3v2})
	{
		$objMP3ID3v2 = $objMP3->{ID3v2};

		($tmpStrGenre, $tmpStrLong) = $objMP3ID3v2->get_frame("TCON");
	}
	else
	{
		print ("WARNING - $tmpStrFile does not have any ID3v2 tags - will get skipped in the AppleScript\n");
		@$tmpRefList[0] = "ERRNOTAGS".@$tmpRefList[0];
	}

	push (@tmpArr2ndDim, @$tmpRefList[0], $tmpStrGenre);
	push (@arrBlankGenres, [ @tmpArr2ndDim ] );
}

open (FH, ">$ENV{'HOME'}/Library/iTunes/Scripts/blank_genres.dat");
	foreach $tmpRefList (@arrBlankGenres)
	{
		print FH @$tmpRefList[0].",".@$tmpRefList[1]."\n";
	}
close (FH);
