#!/opt/local/bin/perl

$glbStrITunesLib = "$ENV{'HOME'}/Music/iTunes/iTunes Music Library.xml";
if (!-e $glbStrITunesLib) { die "ERROR! Cannot find the iTunes XML files\n"; }

open (FH,"<$glbStrITunesLib");
	@lines = <FH>;
close (FH);

$tmpCount = 1;
$boolFindLoc = 0;
@arrToRemove = ();
@arrTracks = ();
@arrTracksSorted = ();
@arr2ndDim = ();
$tmpStrPrevLine = "";

foreach $line (@lines)
{
	chomp $line;
	my $tmpStrLine = $line;

	if ($tmpCount > 1)
	{
		if ( (!$boolFindLoc) && ($tmpStrLine =~ m/<key>Track ID<\/key>/) )
		{
			if ($tmpStrPrevLine =~ m/<dict>/)
			{
				@tmpArrSplit = split("<integer>", $tmpStrLine);
				$tmpArrSplit[1] =~ s/<\/integer>//;
				$arr2ndDim[0] = $tmpArrSplit[1];

				$boolFindLoc = 1;
			}
		}
		elsif ( ($boolFindLoc) && ($tmpStrLine =~ m/<key>Location<\/key>/) )
		{
			@tmpArrSplit = split("<string>file://localhost", $tmpStrLine);
			$tmpArrSplit[1] =~ s/<\/string>//;
			$arr2ndDim[1] = $tmpArrSplit[1];

			$boolFindLoc = 0;

			push (@arrTracks, [ @arr2ndDim ]);
			undef(@arr2ndDim);
		}
	}

	$tmpStrPrevLine = $line;
	$tmpCount++;
}

# Sort @arrToRemove based on the 2nd column
@arrTracksSorted = sort { $a->[1] cmp $b->[1] || $a->[0] cmp $b->[0] } @arrTracks;

$tmpCount = 1;
$tmpRefListPrev = "";

foreach $tmpRefList (@arrTracksSorted)
{
	if ($tmpCount > 1)
	{
		if (@$tmpRefList[1] eq @$tmpRefListPrev[1]) { push (@arrToRemove, @$tmpRefListPrev[0]); }
	}

	$tmpRefListPrev = $tmpRefList;
	$tmpCount++;
}

open (FH, ">$ENV{'HOME'}/Library/iTunes/Scripts/dupes_to_delete.dat");
	foreach $tmpStrID (@arrToRemove)
	{
		print FH $tmpStrID."\n";
	}
close (FH);
